/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.*;
import gov.nasa.worldwind.geom.*;
import gov.nasa.worldwind.layers.*;

import java.util.*;

/**
 * @author tag
 * @version $Id: LandsatI3.java 1830 2007-05-11 18:30:24Z dcollins $
 */
public class LandsatI3 extends TiledImageLayer
{
    public LandsatI3()
    {
        super(makeLevels());
        this.setUseTransparentTextures(true);
    }

    private static LevelSet makeLevels()
    {
        AVList params = new AVListImpl();

        params.setValue(Level.TILE_WIDTH, 512);
        params.setValue(Level.TILE_HEIGHT, 512);
        params.setValue(Level.CACHE_NAME, "Earth/NASA LandSat I3");
        params.setValue(Level.SERVICE, "http://worldwind25.arc.nasa.gov/lstile/lstile.aspx");
        params.setValue(Level.DATASET_NAME, "esat_worlddds");
        params.setValue(Level.FORMAT_SUFFIX, ".dds");
        params.setValue(Level.NUM_LEVELS, 10);
        params.setValue(Level.NUM_EMPTY_LEVELS, 4);
        params.setValue(Level.LEVEL_ZERO_TILE_DELTA, new LatLon(Angle.fromDegrees(36d), Angle.fromDegrees(36d)));
        params.setValue(AVKey.SECTOR, Sector.FULL_SPHERE);
        params.setValue(Level.EXPIRY_TIME, new GregorianCalendar(2007, 2, 22).getTimeInMillis());

        return new LevelSet(params);
    }

    @Override
    public String toString()
    {
        return WorldWind.retrieveErrMsg("layers.Earth.LandsatI3Layer.Name");
    }
}
